/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend.compile.component;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.engine_room.flywheel.backend.compile.component.StringSubstitutionComponent;
import dev.engine_room.flywheel.backend.glsl.ShaderSources;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.backend.glsl.SourceFile;
import dev.engine_room.flywheel.backend.glsl.generate.FnSignature;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBlock;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBuilder;
import dev.engine_room.flywheel.backend.glsl.generate.GlslExpr;
import dev.engine_room.flywheel.backend.glsl.generate.GlslSwitch;
import dev.engine_room.flywheel.lib.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class UberShaderComponent
implements SourceComponent {
    private final class_2960 name;
    private final GlslExpr switchArg;
    private final List<AdaptedFn> functionsToAdapt;
    private final List<StringSubstitutionComponent> adaptedComponents;

    private UberShaderComponent(class_2960 name, GlslExpr switchArg, List<AdaptedFn> functionsToAdapt, List<StringSubstitutionComponent> adaptedComponents) {
        this.name = name;
        this.switchArg = switchArg;
        this.functionsToAdapt = functionsToAdapt;
        this.adaptedComponents = adaptedComponents;
    }

    public static Builder builder(class_2960 name) {
        return new Builder(name);
    }

    @Override
    public String name() {
        return ResourceUtil.rl("uber_shader").toString() + " / " + this.name;
    }

    @Override
    public Collection<? extends SourceComponent> included() {
        return this.adaptedComponents;
    }

    @Override
    public String source() {
        GlslBuilder builder = new GlslBuilder();
        for (AdaptedFn adaptedFunction : this.functionsToAdapt) {
            builder.function().signature(adaptedFunction.signature()).body(body -> this.generateAdapter((GlslBlock)body, adaptedFunction));
            builder.blankLine();
        }
        return builder.build();
    }

    private void generateAdapter(GlslBlock body, AdaptedFn adaptedFunction) {
        GlslSwitch sw = GlslSwitch.on(this.switchArg);
        FnSignature fnSignature = adaptedFunction.signature();
        String fnName = fnSignature.name();
        boolean isVoid = fnSignature.isVoid();
        Collection<? extends GlslExpr> fnArgs = fnSignature.createArgExpressions();
        for (int i = 0; i < this.adaptedComponents.size(); ++i) {
            StringSubstitutionComponent component = this.adaptedComponents.get(i);
            if (!component.replaces(fnName)) continue;
            GlslExpr.FunctionCall adaptedCall = GlslExpr.call(component.remapFnName(fnName), fnArgs);
            GlslBlock block = GlslBlock.create();
            if (isVoid) {
                block.eval(adaptedCall).breakStmt();
            } else {
                block.ret(adaptedCall);
            }
            sw.uintCase(i, block);
        }
        if (!isVoid) {
            GlslExpr defaultReturn = adaptedFunction.defaultReturn;
            if (defaultReturn == null) {
                throw new IllegalStateException("Function " + fnName + " is not void, but no default return value was provided");
            }
            sw.defaultCase(GlslBlock.create().ret(defaultReturn));
        }
        body.add(sw);
    }

    public static class Builder {
        private final class_2960 name;
        private final List<class_2960> materialSources = new ArrayList<class_2960>();
        private final List<AdaptedFn> adaptedFunctions = new ArrayList<AdaptedFn>();
        @Nullable
        private GlslExpr switchArg;

        public Builder(class_2960 name) {
            this.name = name;
        }

        public Builder materialSources(List<class_2960> sources) {
            this.materialSources.addAll(sources);
            return this;
        }

        public Builder adapt(FnSignature function) {
            this.adaptedFunctions.add(new AdaptedFn(function, null));
            return this;
        }

        public Builder adapt(FnSignature function, GlslExpr defaultReturn) {
            this.adaptedFunctions.add(new AdaptedFn(function, defaultReturn));
            return this;
        }

        public Builder switchOn(GlslExpr expr) {
            this.switchArg = expr;
            return this;
        }

        public UberShaderComponent build(ShaderSources sources) {
            if (this.switchArg == null) {
                throw new NullPointerException("Switch argument must be set");
            }
            ImmutableList.Builder transformed = ImmutableList.builder();
            int index = 0;
            for (class_2960 rl : this.materialSources) {
                SourceFile sourceFile = sources.get(rl);
                int finalIndex = index++;
                ImmutableMap<String, String> adapterMap = Builder.createAdapterMap(this.adaptedFunctions, fnName -> "_" + fnName + "_" + finalIndex);
                transformed.add((Object)new StringSubstitutionComponent(sourceFile, (Map<String, String>)adapterMap));
            }
            return new UberShaderComponent(this.name, this.switchArg, this.adaptedFunctions, (List<StringSubstitutionComponent>)transformed.build());
        }

        private static ImmutableMap<String, String> createAdapterMap(List<AdaptedFn> adaptedFunctions, UnaryOperator<String> nameAdapter) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (AdaptedFn adapted : adaptedFunctions) {
                String fnName = adapted.signature().name();
                builder.put((Object)fnName, (Object)((String)nameAdapter.apply(fnName)));
            }
            return builder.build();
        }
    }

    private record AdaptedFn(FnSignature signature, @Nullable GlslExpr defaultReturn) {
    }
}

